VERSION 5.00
Object = "{A11D643E-A762-4BA9-8927-BABC3B51E0D3}#1.0#0"; "Idec_com_V1.6.0.ocx"
Begin VB.Form Form1 
   Caption         =   "Communication test program"
   ClientHeight    =   7395
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   11205
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7395
   ScaleWidth      =   11205
   StartUpPosition =   3  'Windows Default
   Begin Idec_com.Idec_driver Idec_driver1 
      Height          =   2250
      Left            =   840
      TabIndex        =   31
      Top             =   840
      Width           =   1695
      _ExtentX        =   2990
      _ExtentY        =   3969
      Caption         =   "Idec"
   End
   Begin VB.CommandButton Command1 
      Caption         =   "END"
      Height          =   735
      Left            =   3840
      TabIndex        =   30
      Top             =   2640
      Width           =   1335
   End
   Begin VB.CommandButton Send 
      Caption         =   "Send to DR 15"
      Height          =   615
      Left            =   3600
      TabIndex        =   26
      Top             =   4440
      Width           =   1815
   End
   Begin VB.HScrollBar HScroll1 
      Height          =   375
      LargeChange     =   100
      Left            =   480
      TabIndex        =   24
      Top             =   3960
      Width           =   5055
   End
   Begin VB.Timer Timer2 
      Interval        =   20
      Left            =   20
      Top             =   120
   End
   Begin VB.Timer Timer1 
      Interval        =   10
      Left            =   480
      Top             =   120
   End
   Begin VB.CommandButton SET 
      Caption         =   "SET Q5"
      Height          =   735
      Left            =   3840
      TabIndex        =   12
      Top             =   720
      Width           =   1335
   End
   Begin VB.CommandButton RST 
      Caption         =   "RST Q5"
      Height          =   735
      Left            =   3840
      TabIndex        =   11
      Top             =   1680
      Width           =   1335
   End
   Begin VB.CommandButton READDR 
      Caption         =   "Read DR 0-9"
      Height          =   735
      Left            =   6240
      TabIndex        =   10
      Top             =   720
      Width           =   1455
   End
   Begin VB.Label Label3 
      Caption         =   "Reply on cont. read command"
      Height          =   375
      Left            =   360
      TabIndex        =   29
      Top             =   6720
      Width           =   2535
   End
   Begin VB.Label Label2 
      Caption         =   "Reply on drive out command"
      Height          =   375
      Left            =   360
      TabIndex        =   28
      Top             =   6000
      Width           =   2535
   End
   Begin VB.Label Lbl_CRead_Reply 
      Height          =   375
      Left            =   3240
      TabIndex        =   27
      Top             =   6720
      Width           =   7935
   End
   Begin VB.Label VAL_DR15 
      Caption         =   "0"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   480
      TabIndex        =   25
      Top             =   4560
      Width           =   2175
   End
   Begin VB.Label Label1 
      Caption         =   "DR19="
      Height          =   255
      Index           =   19
      Left            =   8760
      TabIndex        =   23
      Top             =   5040
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR18="
      Height          =   255
      Index           =   18
      Left            =   8760
      TabIndex        =   22
      Top             =   4680
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR17="
      Height          =   255
      Index           =   17
      Left            =   8760
      TabIndex        =   21
      Top             =   4320
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR16="
      Height          =   255
      Index           =   16
      Left            =   8760
      TabIndex        =   20
      Top             =   3960
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR15="
      Height          =   255
      Index           =   15
      Left            =   8760
      TabIndex        =   19
      Top             =   3600
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR14="
      Height          =   255
      Index           =   14
      Left            =   8760
      TabIndex        =   18
      Top             =   3240
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR13="
      Height          =   255
      Index           =   13
      Left            =   8760
      TabIndex        =   17
      Top             =   2880
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR12="
      Height          =   255
      Index           =   12
      Left            =   8760
      TabIndex        =   16
      Top             =   2520
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR11="
      Height          =   255
      Index           =   11
      Left            =   8760
      TabIndex        =   15
      Top             =   2160
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR10="
      Height          =   255
      Index           =   10
      Left            =   8760
      TabIndex        =   14
      Top             =   1800
      Width           =   1695
   End
   Begin VB.Label Lbl_Reply 
      Height          =   375
      Left            =   3240
      TabIndex        =   13
      Top             =   6000
      Width           =   7815
   End
   Begin VB.Label Label1 
      Caption         =   "DR00="
      Height          =   255
      Index           =   0
      Left            =   6240
      TabIndex        =   9
      Top             =   1800
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR01="
      Height          =   255
      Index           =   1
      Left            =   6240
      TabIndex        =   8
      Top             =   2160
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR02="
      Height          =   255
      Index           =   2
      Left            =   6240
      TabIndex        =   7
      Top             =   2520
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR03="
      Height          =   255
      Index           =   3
      Left            =   6240
      TabIndex        =   6
      Top             =   2880
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR04="
      Height          =   255
      Index           =   4
      Left            =   6240
      TabIndex        =   5
      Top             =   3240
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR05="
      Height          =   255
      Index           =   5
      Left            =   6240
      TabIndex        =   4
      Top             =   3600
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR06="
      Height          =   255
      Index           =   6
      Left            =   6240
      TabIndex        =   3
      Top             =   3960
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR07="
      Height          =   255
      Index           =   7
      Left            =   6240
      TabIndex        =   2
      Top             =   4320
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR08="
      Height          =   255
      Index           =   8
      Left            =   6240
      TabIndex        =   1
      Top             =   4680
      Width           =   1695
   End
   Begin VB.Label Label1 
      Caption         =   "DR09="
      Height          =   255
      Index           =   9
      Left            =   6240
      TabIndex        =   0
      Top             =   5040
      Width           =   1695
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim ACTION As Integer

Private Sub Command1_Click()
    End
End Sub

' On form load, set parameters and open communication channel
Private Sub Form_Load()
Dim Port_open_error As String
    'Here you have to fill in your name & registration number
    Idec_driver1.Register "Name", "Registration number"
    Idec_driver1.CommPort = COM1
    Idec_driver1.Settings = "9600,e,7,1"
    Idec_driver1.OverTime = 500
    Call Idec_driver1.Open_Port("1", Port_open_error)
End Sub

Private Sub Form_Unload(Cancel As Integer)
' On form unload, close communication channel
Dim Port_open_error As String
    Call Idec_driver1.Open_Port("0", Port_open_error)
    Unload Me
End Sub

Private Sub HScroll1_Change()
    VAL_DR15.Caption = HScroll1.Value
End Sub




' On pressing the SET button
Private Sub SET_Click()
    ACTION = 1
End Sub

Private Sub RST_Click()
    ACTION = 2
End Sub

Private Sub Readdr_Click()
    ACTION = 3
End Sub

Private Sub Send_Click()
    ACTION = 4
End Sub

Private Sub Idec_driver1_ReplyIdecWrite(ByVal User_REF As String, ByVal Device As String, ByVal DataType As String, ByVal Error_Desc As String)
    ' On the reply event of an IdecWrite command, you receive 4 informations
    ' User_REF = User reference = returns the same Reference as used in the IdecWrite command
    '            This is used, to trace about which write command we received the event
    ' Device   = PLC device number, we received the event
    ' DataType = Data type of sended write command
    ' Error_Desc = If this value = 0 then there was no error , otherwise see list for descritions in Appendix A of manual
    
    Lbl_Reply.Caption = User_REF & " / " & Device & " / " & DataType & " / " & Error_Desc & " / " & PLC_DATA
End Sub

Private Sub Idec_driver1_ReplyIdecRead(ByVal User_REF As String, ByVal Device As String, ByVal DataType As String, ByVal PLC_DATA As String, ByVal Error_Desc As String)
' On the reply event of on IdecRead command, you receive the data in PLC_DATA
Dim X
Dim Y As Integer
Dim Z As Integer
Dim VALUES(20) As Single
    If Error_Desc = 0 Then
        If User_REF = "Read_DR0-9" Then
            'This data is received when you push on the Read DR 0-9 button
            Y = (Len(PLC_DATA) / 5) - 1
            For Z = 0 To Y
                VALUES(Z) = CSng(Val(Mid(PLC_DATA, 1 + (Z * 5), 5)))
                Label1(Z) = "DR" & Z & "= " & VALUES(Z)
            Next Z
            Lbl_Reply.Caption = User_REF & " / " & Device & " / " & DataType & " / " & Error_Desc & " / " & PLC_DATA
        End If
        If User_REF = "Read_DR10-19" Then
            'This data is received from the continuously read command (DR10 - DR19)
            Y = (Len(PLC_DATA) / 5) - 1
            For Z = 0 To Y
                VALUES(Z + 10) = CSng(Val(Mid(PLC_DATA, 1 + (Z * 5), 5)))
                Label1(Z + 10) = "DR" & Z + 10 & "= " & VALUES(Z + 10)

            Next Z
            Lbl_CRead_Reply.Caption = User_REF & " / " & Device & " / " & DataType & " / " & Error_Desc & " / " & PLC_DATA
        End If
    Else
        If User_REF = "Read_DR0-9" Then
            Lbl_Reply.Caption = User_REF & " / " & Device & " / " & DataType & " / " & Error_Desc & " / " & PLC_DATA
        End If
        If User_REF = "Read_DR10-19" Then
            Lbl_CRead_Reply.Caption = User_REF & " / " & Device & " / " & DataType & " / " & Error_Desc & PLC_DATA
        End If

    End If
End Sub

Private Sub Timer1_Timer()
' To avoid sending multiple commands at the same time to the PLC, it's better to
' keep all communication commands in one subroutine
    Dim data As String
    If Idec_driver1.Busy_Flag = 0 Then
        ' The Busy_Flag must be 0 before sending the next command, otherwise
        ' you will receive an Error_Code 10 in the reply event
        Select Case ACTION
            Case 1
                Idec_driver1.IdecWrite "SET_Q", "0", "q", "5", "00001", "1"
                ACTION = 0
            Case 2
                Idec_driver1.IdecWrite "RST_Q", "0", "q", "5", "00000", "1"
                ACTION = 0
            Case 3
                Idec_driver1.IdecRead "Read_DR0-9", "0", "D", "0", "10"
                ACTION = 0
            Case 4
                data = Right("00000" & VAL_DR15.Caption, 5)
                Idec_driver1.IdecWrite "SEND", "0", "D", "15", data, "1"
                ACTION = 0
            Case 5
                Idec_driver1.IdecRead "Read_DR10-19", "0", "D", "10", "10"
                ACTION = 0
        End Select
    End If
End Sub

Private Sub Timer2_Timer()
    'This timer is used to create a continuously sended command
    If ACTION = 0 And Idec_driver1.Busy_Flag = 0 Then
        ACTION = 5
    End If
End Sub
